
#define MAX_LIGHTS 14

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];



uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];


uniform float lightsAmbientr[MAX_LIGHTS];
uniform float lightsAmbientg[MAX_LIGHTS];
uniform float lightsAmbientb[MAX_LIGHTS];

uniform float lightsDiffuser[MAX_LIGHTS];
uniform float lightsDiffuseg[MAX_LIGHTS];
uniform float lightsDiffuseb[MAX_LIGHTS];

uniform float lightsSpecularr[MAX_LIGHTS];
uniform float lightsSpecularg[MAX_LIGHTS];
uniform float lightsSpecularb[MAX_LIGHTS];


uniform float mirrored;
uniform mat4 rmat;
uniform int renderdepth;

uniform float testvalue;
uniform float ax;
uniform float ay;
uniform float az;


const int ddccount=20;

vec3 currentcolor;
vec3 usecolor;
vec3 totalcolor;
float currentindex;
float useindex;
float totalindex;

uniform vec3 ddccolors[ddccount];
uniform vec3 ddcvectors[ddccount];
uniform mat3 ddcanglematrices[ddccount];
uniform float ddcvectormult[ddccount];

uniform float ddcscroll;


int rendertoshadowmap=0;


const float pi=3.14159265359;
const float dpi=pi*2.0;

vec4 poz;


int sceneselect=0;

uniform float rfactor;
uniform int refractmode;

const float normaleps=0.005;


const float precision_=0.001;

const int steps=60;



   const float tmin =     0.0000001;

const float tmax = 20.0;





uniform float twistfader;
uniform float twistoutrofader;
uniform float noisefade;
uniform float exitangle;
uniform float iTimetwist;                


vec3 iResolution= vec3(1920,1080,0);          
uniform float iTime;                
float sphereanim1=iTime/2.0/1.3;
float sphereanim2=iTime/1.3/1.3;

float twistanim1=iTimetwist/2.0/1.3;
float twistanim2=iTimetwist/1.3/1.3;






vec4 iMouse= vec4(1920/2,1080/2,0,0);               





uniform mat4 mat4cam;
uniform mat4 Rotation;
uniform mat4 Rotation2;



uniform float masterscale;




uniform vec3 t1;
uniform vec3 t2;
uniform vec3 t3;

uniform vec3 rayorigin;
uniform vec3 raydirection;
uniform vec3 upvector;

uniform float fov;


const float depthmult=20.0;
const float depthmax=19.3872;


const float scale=1.0;

varying vec2 texCoord;

float depth;
float depthbig;
mat3 ca;



uniform sampler2D colorMap;
uniform sampler2D depthMap;
uniform samplerCube envMap;
uniform sampler2D palette;


vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

const float F3 =  0.3333333;
const float G3 =  0.1666667;

float simplex3d(vec3 p) {
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

     
     

	 vec4 w, d;

	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 w = max(0.6 - w, 0.0);

	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 w *= w;
	 w *= w;
	 d *= w;

	 return dot(d, vec4(52.0));
}

const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

float simplex3d_fractal(vec3 m) {
    return   0.5333333*simplex3d(m*rot1)
			+0.2666667*simplex3d(2.0*m*rot2)
			+0.1333333*simplex3d(4.0*m*rot3)
			+0.0666667*simplex3d(8.0*m);
}

void mainImageSimplex( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = fragCoord.xy/1920.0;
	vec3 p3 = vec3(p, iTime*0.025);

	float value;

	if (p.x <= 0.6) {
		value = simplex3d(p3*32.0);
	} else {
		value = simplex3d_fractal(p3*8.0+8.0);
	}

	value = 0.5 + 0.5*value;
	value *= smoothstep(0.0, 0.005, abs(0.6-p.x)); 

	fragColor = vec4(
			vec3(value),
			1.0);
	return;
}


































in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.








#define AA 0   



float sdPlane( vec3 p )
{
    return p.y;
}

float sdSphere( vec3 p, float s )
{
    return length(p)-s;
}

float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdEllipsoid( in vec3 p, in vec3 r )
{
    return (length( p/r ) - 1.0) * min(min(r.x,r.y),r.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
    return length(max(abs(p)-b,0))-r;
}


float Ellipsoid2( vec3 p, vec3 r )
{
    
    
    
    return length((p)*float(normalize(r))) - float(r)/length(r);

    
      
}

float sdTorus( vec3 p, vec2 t )
{
    return length( vec2(length(p.xz)-t.x,p.y) )-t.y;
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
#if 0
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
#else
    float d1 = q.z-h.y;
    float d2 = max((q.x*0.866025+q.y*0.5),q.y)-h.x;
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
#endif
}

float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}

float sdEquilateralTriangle(  in vec2 p )
{
    const float k = sqrt(3.0);
    p.x = abs(p.x) - 1.0;
    p.y = p.y + 1.0/k;
    if( p.x + k*p.y > 0.0 ) p = vec2( p.x - k*p.y, -k*p.x - p.y )/2.0;
    p.x += 2.0 - 2.0*clamp( (p.x+2.0)/2.0, 0.0, 1.0 );
    return -length(p)*sign(p.y);
}

float sdTriPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    float d1 = q.z-h.y;
#if 1
    
    float d2 = max(q.x*0.866025+p.y*0.5,-p.y)-h.x*0.5;
#else
    
    h.x *= 0.866025;
    float d2 = sdEquilateralTriangle(p.xy/h.x)*h.x;
#endif
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdCylinder( vec3 p, vec2 h )
{
    vec2 d = abs(vec2(length(p.xz),p.y)) - h;
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdCone( in vec3 p, in vec3 c )
{
    vec2 q = vec2( length(p.xz), p.y );
    float d1 = -q.y-c.z;
    float d2 = max( dot(q,c.xy), q.y);
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdConeSection( in vec3 p, in float h, in float r1, in float r2 )
{
    float d1 = -p.y - h;
    float q = p.y - h;
    float si = 0.5*(r1-r2)/h;
    float d2 = max( sqrt( dot(p.xz,p.xz)*(1.0-si*si)) + q*si - r2, q );
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdPryamid4(vec3 p, vec3 h ) 
{
    
    float box = sdBox( p - vec3(0,-2.0*h.z,0), vec3(2.0*h.z) );

    float d = 0.0;
    d = max( d, abs( dot(p, vec3( -h.x, h.y, 0 )) ));
    d = max( d, abs( dot(p, vec3(  h.x, h.y, 0 )) ));
    d = max( d, abs( dot(p, vec3(  0, h.y, h.x )) ));
    d = max( d, abs( dot(p, vec3(  0, h.y,-h.x )) ));
    float octa = d - h.z;
    return max(-box,octa); 
}

float length2( vec2 p )
{
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p )
{
    p = p*p*p;
    p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p )
{
    p = p*p;
    p = p*p;
    p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus82( vec3 p, vec2 t )
{
    vec2 q = vec2(length2(p.xz)-t.x,p.y);
    return length8(q)-t.y;
}

float sdTorus88( vec3 p, vec2 t )
{
    vec2 q = vec2(length8(p.xz)-t.x,p.y);
    return length8(q)-t.y;
}

float sdCylinder6( vec3 p, vec2 h )
{
    return max( length6(p.xz)-h.x, abs(p.y)-h.y );
}



vec2 opS( vec2 d1, vec2 d2 )
{
    return (d1.x>-d2.x) ? d1 : -d2;
}

vec2 opU( vec2 d1, vec2 d2 )
{
    return (d1.x<d2.x) ? d1 : d2;
}

vec3 opRep( vec3 p, vec3 c )
{
    return mod(p,c)-0.5*c;
}

vec3 opTwistFlag( vec3 p )
{
    const float repeat = 6.0;
    const float speedup = 4.0;

    
    vec3 vp=p;
    const float va_1=1.0f/5.0*repeat; 
    const float va_2=1.0f/7.5*repeat; 
    float vb_1=twistanim1*speedup;
    float vb_2=twistanim2;
    float vc_1=0.0;
    
    
    float vsinx=va_1*vp.x+vb_1;

    vsinx=sin(vsinx)*6.28f/12.0;


    float vc = cos(vsinx);
    float vs = sin(vsinx);
    mat2 vm = mat2(vc,-vs,vs,vc);
    
    
    vec3 twist2 = vec3(vp.x,(vm*vp.yz).x,(vm*vp.yz).y);


    vec3 hp=twist2;

    const float a_1=1.0f/6.0*repeat; 
    const float a_2=1.0f/6.5*repeat; 
    float b_1=twistanim1*speedup*1.25f;
    float b_2=twistanim2;
    float c_1=4.0*sin(twistanim1*1.5);
    
    
    float sinx=a_1*hp.y+b_1 + a_2*p.y*c_1+b_2;
    sinx=sin(sinx)*6.28f/12.0f+6.28f/4.0;
    
    float  c = cos(sinx);
    float  s = sin(sinx);
    mat2   m = mat2(c,-s,s,c);
    
    

    vec3 twist1=vec3((m*hp.xz).y,p.y,(m*hp.xz).x);


    return twist1;
}


vec3 opTwist2( vec3 p )
{
        return p;
}

vec3 opTwistBnz( vec3 p )
{
    

    const float a_1=1.0f/2.0; 
    const float a_2=1.0f/6.5; 
    float b_1=twistanim1;
    float b_2=twistanim2;
    float c_1=2.0*sin(twistanim1/1.1+p.y/8.0);
    float sinx=c_1;
    
    
    
    

    float  c = cos(sinx);
    float  s = sin(sinx);
    mat2   m = mat2(c,-s,s,c);

    vec3 twist1=vec3((m*p.xz).y,p.y,(m*p.xz).x);
    return twist1;
}

vec3 opTwist( vec3 p )
{
    
    

    const float a_1=1.0/2.0; 
    const float a_2=1.0/6.5; 
    float b_1=twistanim1;
    float b_2=twistanim2;
    float c_1=4.0*sin(twistanim1*1.5);
    
    float sinx=a_1*p.y+b_1;
    
    sinx*=twistfader;
        
        
        

    sinx=sinx+twistoutrofader*(exitangle-sinx);
    

    
    float parkarea=sinx-(exitangle-6.28/2.0);
    if (parkarea>0.0) {
        float sinxx=parkarea/(6.28/2.0);
        sinxx=clamp(sinxx,0.0,1.0);
        sinxx*=6.28/4.0;
        sinx/=1.0+sin(sinxx)/10.0*2.0/5.0; 
    }
    

    if (sinx>exitangle) sinx=exitangle;
    sinx+=6.28/4.0;

    sinx+=((sinx/exitangle)*6.28/16.0); 

    float  c = cos(sinx);
    float  s = sin(sinx);
    mat2   m = mat2(c,-s,s,c);

    

    vec3 twist1=vec3((m*p.xz).y,p.y,(m*p.xz).x);

    
    vec3 vp=twist1;
    const float va_1=1.0/5.0; 
    const float va_2=1.0/7.5; 
    float vb_1=twistanim1*1.3; 
    float vb_2=twistanim2*2.0;
    float vc_1=0.0;
    
    float vsinx=va_1*vp.x+vb_1;
    

    vsinx=sin(vsinx)*6.28/8.0;
    
    vsinx*=twistfader;
    float vfadeout=pow((1.0-twistoutrofader),2.0);
    vsinx*=vfadeout;
    


    float vc = cos(vsinx);
    float vs = sin(vsinx);
    mat2 vm = mat2(vc,-vs,vs,vc);
    
    
    vec3 twist2 = vec3(vp.x,(vm*vp.yz).x,(vm*vp.yz).y);

    return twist2;
}

vec3 twistCenter( vec3 p2)
{
    return p2;
    return vec3(p2.x,p2.y,p2.z);

    const float a=1.0/4.0; 
    float b=twistanim1;
    float c2 = cos(a*p2.y+b);
    float s2 = sin(a*p2.y+b);

    

    float x=p2.x*c2;
    float z=p2.z*s2;
    


    mat2  m2 = mat2(c2,-s2,s2,c2);
    return vec3((m2*p2.xz).y,p2.y,(m2*p2.xz).x);
}



float opI( vec2 d1, vec2 d2 ) 

{return (d1.x>d2.x) ? float(d1) : float(d2);}

vec2 opSmoothIntersection( vec2 d1, vec2 d2, float k ) {
    float h = clamp( 0.5 - 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    return vec2(mix( d2.x, d1.x, h ) + k*h*(1.0-h),17.0); }

vec2 opUs( vec2 d1, vec2 d2, float k ) {
    float h = clamp( 0.5 + 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    return vec2(mix( d2.x, d1.x, h ) - k*h*(1.0-h), d1.y); }

vec2 opUsWithColor( vec2 d1, vec2 d2, float k) {
    float h = clamp( 0.5 + 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    
    
    useindex=mix( currentindex, totalindex, h );
    totalindex=useindex;
    return vec2(mix( d2.x, d1.x, h ) - k*h*(1.0-h), d1.y); }

vec2 opSs( vec2 d1, vec2 d2, float k ) {
    float h = clamp( 0.5 + 0.5*(-d2.x-d1.x)/k, 0.0, 1.0 );
    return vec2(mix( d1.x, -d2.x,  h ) + k*h*(1.0-h), d1.y); }

vec2 opSs_( vec2 d1, vec2 d2, float k ) {
    float h = clamp( 0.5 - 0.5*(d2.x+d1.x)/k, 0.0, 1.0 );
    return vec2(mix( d2.x, -d1.x, h ) + k*h*(1.0-h),d1.y); }

vec2 opS_( vec2 d1, vec2 d2 ){
    return (d1.x>-d2.x) ? d1 : -d2; }

vec2 blob2s( vec2 d1, vec2 d2, float k) {
    
    float h = clamp( 0.5 + 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    float color=(0.5f-abs(0.5f-h))*2.0;
    return vec2(mix( d2.x, d1.x, h ) - k*h*(1.0-h), color); }

float blob2(float d1, float d2)
{
    float k = 4.5;
    return -log(exp(-k*d1)+exp(-k*d2))/k;
}
float blob3(float d1, float d2,float d3)
{
    float k = 4.5;
    return -log(exp(-k*d1)+exp(-k*d2)+exp(-k*d3))/k;
}



vec2 map2_old( in vec3 pos ) 
{
    vec2 res=vec2(15.0, -100.0);

float x=3.5*sin(sphereanim1);
float y=2.0*sin(sphereanim2);
pos-=vec3(x,y,0.0);

vec4 pb2=vec4(pos,1.0);
pb2 = Rotation2 * pb2;
pos=vec3(pb2.xyz);


vec3 pos2=pos;
pos2=pos2+vec3(1.7*sin(sphereanim1/1.5),1.5*cos(sphereanim2/1.3),0.0);

const float logoscale=3.0;
const float k=0.275;
const float k2=0.25;

const float r=2.0;
const float disp=0.75;
const float boxsize=0.3;
vec3 center;
center=vec3(0.0,0.0,0.0);
vec2 res2=vec2(15.0, 17.0);
center=twistCenter(vec3(0.0,0.0,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(r/3,r/3,r/3),k2), 17.0),k); 

res2 = opUs( res2, vec2(sdSphere(opTwist2(pos)+center,r/1.1), 17.0),k);

center=twistCenter(vec3(-r*disp,0.0,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(r*disp,0.0,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,r*disp,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,-r*disp,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,0.0,-r*disp));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,0.0,r*disp));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);

vec2 resnoise=vec2(simplex3d(pos2+iTime/10.0),1.0);
float a=resnoise.x; a=a+noisefade; a=clamp(a,-1.0,1.0); resnoise.x=a; 
if (noisefade<=-1.9) 
    res=res2;
else
    res=vec2(opI(resnoise,res2),17.0);
res.y=1.0;

    return res;
}


vec2 map4( in vec3 pos ) 
{
vec3 p=pos;

    vec2 res=vec2(15.0, -100.0);
vec4 pb2=vec4(pos,1.0);
pb2 = Rotation * pb2;
pos=vec3(pb2.xyz);

const float logoscale=3.0;
const float k=0.7f;
const float k2=0.25;

const float r=2.0;
const float disp=0.75;
const float boxsize=0.3;
vec3 center;
center=vec3(0.0,0.0,0.0);
vec2 res2=vec2(15.0, 17.0);


const float rddc=3.25;
const float d2r=3.14159265359*2.0f/360.0;


totalindex=0.0;
for (int i=0;i<20;i++){
    
    
    vec3 rot1=(pos+ddcvectors[i])*ddcanglematrices[i];
    
    float elsize=6.0f*ddcvectormult[i]*masterscale;
    
    
    
    
    currentindex=float(i);
    
    res2 = opUs(res2, vec2(sdEllipsoid(rot1,vec3(0.1f*elsize,0.1f*elsize,0.2f*elsize)),17.0),k);
}




res2.y=1.0;
return res2;


}


float k=0.275*masterscale;
float k2=0.35*masterscale;
float boxsize=1.5*masterscale;
float squish;

float wtime;
float rebouncefactor,rebouncefactor2;
bool rewobble;
uniform float bnzdisplacey;

vec3 opBnz(vec3 p,vec3 move){

    p-=vec3(0,bnzdisplacey,0);

    float x,z;
    const float wxp=0.7;
    float wobble=boxsize/2.0*0.2*1.9;
    float center=boxsize/2.0-k2*1.15;
    float centery=boxsize/2.0/squish;

    x=p.x;z=p.z;
    p.y+=0.75;

    float y=(p.y+move.y)/centery/8.0*pi+pi/2.0; 
    if (rewobble){
        x=x+(p.x-center)*wobble*pow(abs(sin(y)),wxp)*sign(sin(y))*rebouncefactor2;
        z=z+(p.z-center)*wobble*pow(abs(sin(y)),wxp)*sign(sin(y))*rebouncefactor2;
    }
    else {
        x=x+(p.x-center)*wobble*pow(abs(sin(y)),wxp)*sign(sin(y))*sin(wtime);
        z=z+(p.z-center)*wobble*pow(abs(sin(y)),wxp)*sign(sin(y))*sin(wtime);
    }

    
    
    p=vec3(x,p.y*squish,z);
    p=opTwistBnz(p);

    p =(vec4(p,1.0)*Rotation).xyz;

    return p;

    
}


vec2 map3( in vec3 pos ) 
{

const float xp=0.75;
const float speedup=3.0;
const float bouncetimeoffset=dpi/2.0;

float sqtime;
float time2=iTime*speedup/2.0*4.0;
float ytime=mod(iTime*speedup/2.0,dpi)+bouncetimeoffset;

vec3 bouncey;
bouncey=vec3(0.0,1.0-2.0*pow(clamp(1.0*sin(ytime),0.0,1.0),xp),0.0);

wtime=mod(iTime*speedup/2.0,dpi)+bouncetimeoffset;
if (wtime>0&&wtime<pi){
    wtime=0;
    sqtime=0;
}
else{
    wtime=-(wtime-pi);
    sqtime=wtime;
}
float squish_=(pow(abs(sin(sqtime)),xp))*sign(sin(sqtime)); 



if (squish_<0.0){
    squish=1.0-squish_;
    bouncey.y-=boxsize/squish;
    bouncey.y+=boxsize;
}
else{
    squish=1.0;
}

bouncey.y+=2.0-0.55;

float ytime_=mod(ytime,dpi);
if (ytime_>0&&ytime_<pi){
    ytime_=mod(ytime,pi);
    
    
    rebouncefactor2=pow(sin(ytime_),1.0); 
    ytime_/=pi;
    rebouncefactor=1-pow(sin(ytime_),1.0); 

    float squish2=(1.0+(1.0+sin(time2))/3.0); 
    

    

    rewobble=true;
}
else
    rewobble=false;




vec2 res2=vec2(15.0, 17.0);

res2 = opU( res2, vec2( udRoundBox(opBnz(pos+bouncey,vec3(0)), vec3(boxsize,boxsize,boxsize),k2), 17.0));





vec2 res=res2;
res.y=1.0;

    return res;
}



vec3 mirror (in vec3 pos){
vec3 rpos;
    if (mirrored>0.0) 
    
    {
        vec4 mpos; mpos=vec4(pos,1.0); 
        mpos=rmat*mpos;
        rpos=mpos.xyz;
    }
    else
        rpos=pos;
    return rpos;
}
















mat4 scale_(float f){
    return mat4(
        vec4(f, 0, 0, 0),
        vec4(0, f, 0, 0),
        vec4(0, 0, f, 0),
        vec4(0, 0, 0, 1)
    );
}
mat4 rotateY(float theta) {
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(c, 0, s, 0),
        vec4(0, 1, 0, 0),
        vec4(-s, 0, c, 0),
        vec4(0, 0, 0, 1)
    );
}

mat4 rotateX(float theta) {
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(1, 0, 0, 0),
        vec4(0, c, -s, 0),
        vec4(0, s, c, 0),
        vec4(0, 0, 0, 1)
    );
}

mat4 rotateZ(float theta) { 
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(c, -s, 0, 0),
        vec4(s, c, 0, 0),
        vec4(0, 0, 1, 0),
        vec4(0, 0, 0, 1)
    );
}


bool flipp=false;
float sdPyramid( in vec3 p, in float h, in vec3 scale )
{
    
    
    
  
    p.x/=scale.x;
    p.y/=scale.y;
    p.z/=scale.z;

    
    if (flipp)
    {
        
        p.y-=1.0;
        p=(vec4(p,1.0)*rotateX(3.14)).xyz;
    }

    float m2 = h*h + 0.25;
    
    
    p.xz = abs(p.xz); 
    p.xz = (p.z>p.x) ? p.zx : p.xz;
    p.xz -= 0.5;
	
    
    vec3 q = vec3( p.z, h*p.y-0.5*p.x, h*p.x+0.5*p.y);
        
    float s = max(-q.x,0.0);
    float t = clamp( (q.y-0.5*q.x)/(m2+0.25), 0.0, 1.0 );
    
    float a = m2*(q.x+s)*(q.x+s) + q.y*q.y;
	float b = m2*(q.x+0.5*t)*(q.x+0.5*t) + (q.y-m2*t)*(q.y-m2*t);
    
    float d2 = max(-q.y,q.x*m2+q.y*0.5) < 0.0 ? 0.0 : min(a,b);
    
    
    return sqrt( (d2+q.z*q.z)/m2 ) * sign(max(q.z,-p.y));;
}

float opUp( float d1, float d2 ) { 
if (d1<d2) return d1; else return d2;

}

float opSubstP( float d1, float d2 ) { return max(-d1,d2); }
float sdBoxP( vec3 p, vec3 b )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}


float pyramid2(vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight)
{
    vec3 pos=position;
    pos.y+=0.01;
    
    
    
    float hei=1.0;
    float h2=0.05; 
    vec3 scale=vec3(1.4,1.0,1.4);
    float py=sdPyramid(pos,hei,scale);
    vec3 posbox=pos; posbox+=vec3(0,-hei-h2,0);
    float box=sdBoxP(posbox,vec3(3.5,hei,3.5));
    py=opSubstP(box,py);
    return py;
}

float pyramid3(vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight)
{
    vec3 pos=position;
    pos.y-=0.2;
    pos=(vec4(pos,1.0)*rotateZ(3.14)).xyz;
    
    
    
    float hei=0.6;
    float h2=0.075;
    vec3 scale=vec3(1.5,1.0,1.5);
    flipp=true;
    float py=sdPyramid(pos,hei,scale);
    flipp=false;
    vec3 posbox=pos; posbox+=vec3(0,-hei-h2,0);
    float box=sdBoxP(posbox,vec3(3.5,hei,3.5));
    
    return py;
}

float pyramid4(vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight)
{
    vec3 pos=position;
    pos.y-=0.2;
    pos.x-=0.2;
    pos=(vec4(pos,1.0)*rotateZ(3.14)).xyz;
    
    
    
    float hei=0.6;
    float h2=0.075;
    
    vec3 scale=vec3(1.5,1.0,1.5);
    flipp=true;
    float py1=sdPyramid(pos-vec3(0.3,0,0),hei,scale);
    float py2=sdPyramid(pos,hei,scale+vec3(2.0,0,0));
    float py3=sdPyramid(pos+vec3(0.3,0,0),hei,scale);
    flipp=false;
    vec3 posbox=pos; posbox+=vec3(0,-hei-h2,0);
    float box=sdBoxP(posbox,vec3(3.5,hei,3.5));
    
    float py=opUp(opUp(py1,py2),py3);
    return py;
}

float pyramid3_(vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight)
{
    vec3 pos=position;
    
    pos.y-=0.01;
    pos=(vec4(pos,1.0)*rotateX(3.14)).xyz;
    
    
    
    const float sc=1.5;
    float hei=0.1/0.05/sc;
    float h2=0.075/2.25*15.0;
    vec3 scale=vec3(0.2*sc,1.0,0.2*sc);
    float py=sdPyramid(pos,hei,scale);
    vec3 posbox=pos; posbox+=vec3(0,+hei+h2,0);
    float box=sdBoxP(posbox,vec3(0.2,hei,0.2));
    py=opSubstP(box,py);
    return py;
}


float sdf(in vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight) { 
    float cornerRadius = 0.0001; 
    float d = pyramid2(position, halfWidth1, halfDepth1, halfWidth2, halfDepth2, halfHeight);
    
    return d;
}
float sdf2(in vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight) { 
    float cornerRadius = 0.0001; 
    float d = pyramid2(position, halfWidth1, halfDepth1, halfWidth2, halfDepth2, halfHeight);
    return d;
}

float sdf3(in vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight) { 
    float cornerRadius = 0.0001; 
    float d = pyramid3(position, halfWidth1, halfDepth1, halfWidth2, halfDepth2, halfHeight);
    return d;
}

float sdf4(in vec3 position, float halfWidth1, float halfDepth1, float halfWidth2, float halfDepth2, float halfHeight) { 
    float cornerRadius = 0.0001; 
    float d = pyramid4(position, halfWidth1, halfDepth1, halfWidth2, halfDepth2, halfHeight);
    return d;
}



float opS2( float d1, float d2 ) { return max(-d1,d2); }




vec2 map_(in vec3 pos){
vec2 res=vec2(15.0, -100.0);









float iTime_=iTime/936.0-(length(pos)*0.75);


float ax,ay,az;




az=iTime_*1.1025/1.5;
ay=iTime_/1.5*0.980000019073486;
ax=iTime_*1.055/1.5;

pos=(vec4(pos,1.0)*rotateZ(az)).xyz;
pos=(vec4(pos,1.0)*rotateY(ay+3.14)).xyz;
pos=(vec4(pos,1.0)*rotateX(ax)).xyz;

pos.y*=1.315;
pos*=0.96; 

float d;
float db;
float d1,d2,d3,d4,d5,d6;
float f1,f2,f3,f4,f5,f6;
float fb1,fb2,fb3,fb4,fb5,fb6;

d1=sdBox(pos,vec3(0.7,0.1,0.7));
d2=sdBox(pos+vec3(-0.1,0,-0.4),vec3(0.4,0.3,0.1));
d3=sdBox(pos+vec3(-0.1,0,0),vec3(0.4,0.3,0.1));
d4=sdBox(pos+vec3(-0.1,0,0.4),vec3(0.4,0.3,0.1));
d5=sdBox(pos+vec3(0.4,0,0.2),vec3(0.1,0.3,0.1));
d6=sdBox(pos+vec3(0.4,0,-0.2),vec3(0.1,0.3,0.1));



const float he=0.7*2.0;
const float adj=-0.005;
const float adj2=0.02;
const float adj3=-0.04;

f1=sdf2(pos+vec3(0,+0.01-0.1-0.03*he-adj+adj2,0),0.7,0.7,0.67,0.67,0.03*he);



pos=(vec4(pos,1.0)*rotateZ(3.14)).xyz;
f2=sdf4(pos+vec3(0.275,+0.01-0.1-0.03*he-adj+adj3,-0.4),0.4,0.1,0.475,0.15,0.04*he);
f3=sdf4(pos+vec3(0.275,+0.01-0.1-0.03*he-adj+adj3,0.0),0.4,0.1,0.475,0.15,0.04*he);
f4=sdf4(pos+vec3(0.275,+0.01-0.1-0.03*he-adj+adj3,0.4),0.4,0.1,0.475,0.15,0.04*he);


f5=sdf3(pos+vec3(-0.4,+0.01-0.1-0.03*he-adj+adj3,0.2),0.1,0.1,0.15,0.15,0.04*he);
f6=sdf3(pos+vec3(-0.4,+0.01-0.1-0.03*he-adj+adj3,-0.2),0.1,0.1,0.15,0.15,0.04*he);
vec3 posb=pos;

fb1=sdf2(posb+vec3(0,+0.01-0.1-0.03*he-adj+adj2,0),0.7,0.7,0.67,0.67,0.03*he);






posb=(vec4(posb,1.0)*rotateZ(3.14)).xyz;
fb2=sdf4(posb+vec3(0.1,+0.01-0.1-0.03*he-adj+adj3,-0.4),0.4,0.1,0.475,0.15,0.04*he);
fb3=sdf4(posb+vec3(0.1,+0.01-0.1-0.03*he-adj+adj3,0.0),0.4,0.1,0.475,0.15,0.04*he);
fb4=sdf4(posb+vec3(0.1,+0.01-0.1-0.03*he-adj+adj3,0.4),0.4,0.1,0.475,0.15,0.04*he);
fb5=sdf3(posb+vec3(0.4,+0.01-0.1-0.03*he-adj+adj3,0.2),0.1,0.1,0.15,0.15,0.04*he);
fb6=sdf3(posb+vec3(0.4,+0.01-0.1-0.03*he-adj+adj3,-0.2),0.1,0.1,0.15,0.15,0.04*he);

d=(opU(vec2(d1,1),vec2(f1,1))).x;
d=(opS(vec2(d,1),vec2(f2,1))).x;
d=(opS(vec2(d,1),vec2(f3,1))).x;
d=(opS(vec2(d,1),vec2(f4,1))).x;
d=(opS(vec2(d,1),vec2(f5,1))).x;
d=(opS(vec2(d,1),vec2(f6,1))).x;

db=fb1;
db=(opS(vec2(db,1),vec2(fb2,1))).x;
db=(opS(vec2(db,1),vec2(fb3,1))).x;
db=(opS(vec2(db,1),vec2(fb4,1))).x;
db=(opS(vec2(db,1),vec2(fb5,1))).x;
db=(opS(vec2(db,1),vec2(fb6,1))).x;

d=(opU(vec2(d,1),vec2(db,1))).x;

d=(opS(vec2(d,1),vec2(d2,1))).x;
d=(opS(vec2(d,1),vec2(d3,1))).x;
d=(opS(vec2(d,1),vec2(d4,1))).x;
d=(opS(vec2(d,1),vec2(d5,1))).x;
d=(opS(vec2(d,1),vec2(d6,1))).x;

res=(opU(vec2(d,1),res));
return res;


float a=1.0;
float b=3.0;
float c=2.0;
float x=pos.x+2.0;
float y=pos.y;
float z=pos.z-1.0;



return d;
}


vec2 map_old(in vec3 pos){
vec2 res=vec2(100.0,-100.0);


float iTime_=iTime/920.0-(length(pos)*0.75);


float ax,ay,az;
az=iTime_*1.005;
ay=iTime_;
ax=iTime_*1.008;

pos=(vec4(pos,1.0)*rotateZ(az)).xyz;
pos=(vec4(pos,1.0)*rotateY(ay)).xyz;
pos=(vec4(pos,1.0)*rotateX(ax)).xyz;

float sf=1.0;

float d;
float db;
float d1,d2,d3,d4,d5,d6;
float f1,f2,f3,f4,f5,f6;
float fb1,fb2,fb3,fb4,fb5,fb6;

d1=sdBox(pos,vec3(0.7,0.1,0.7)*sf);
d2=sdBox(pos+vec3(-0.1,0,-0.4)*sf,vec3(0.4,0.3,0.1)*sf);
d3=sdBox(pos+vec3(-0.1,0,0)*sf,vec3(0.4,0.3,0.1)*sf);
d4=sdBox(pos+vec3(-0.1,0,0.4)*sf,vec3(0.4,0.3,0.1)*sf);
d5=sdBox(pos+vec3(0.4,0,0.2)*sf,vec3(0.1,0.3,0.1)*sf);
d6=sdBox(pos+vec3(0.4,0,-0.2)*sf,vec3(0.1,0.3,0.1)*sf);



const float he=0.7;
const float adj=-0.005;
f1=sdf(pos+vec3(0,-0.1-0.03*he-adj,0)*sf,0.7*sf,0.7*sf,0.67*sf,0.67*sf,0.03*he*sf);
f2=sdf(pos+vec3(-0.1,-0.1-0.04*he-adj,-0.4)*sf,0.4*sf,0.1*sf,0.475*sf,0.15*sf,0.04*he*sf);
f3=sdf(pos+vec3(-0.1,-0.1-0.04*he-adj,0.0)*sf,0.4*sf,0.1*sf,0.475*sf,0.15*sf,0.04*he*sf);
f4=sdf(pos+vec3(-0.1,-0.1-0.04*he-adj,0.4)*sf,0.4*sf,0.1*sf,0.475*sf,0.15*sf,0.04*he*sf);
f5=sdf(pos+vec3(0.4,-0.1-0.04*he-adj,0.2)*sf,0.1*sf,0.1*sf,0.15*sf,0.15*sf,0.04*he*sf);
f6=sdf(pos+vec3(0.4,-0.1-0.04*he-adj,-0.2)*sf,0.1*sf,0.1*sf,0.15*sf,0.15*sf,0.04*he*sf);

vec3 posb=(vec4(pos,1.0)*rotateZ(3.14)).xyz;

fb1=sdf(posb+vec3(0,-0.1-0.03*he-adj,0)*sf,0.7*sf,0.7*sf,0.67*sf,0.67*sf,0.03*he*sf);
fb2=sdf(posb+vec3(0.1,-0.1-0.04*he-adj,-0.4)*sf,0.4*sf,0.1*sf,0.475*sf,0.15*sf,0.04*he*sf);
fb3=sdf(posb+vec3(0.1,-0.1-0.04*he-adj,0.0)*sf,0.4*sf,0.1*sf,0.475*sf,0.15*sf,0.04*he*sf);
fb4=sdf(posb+vec3(0.1,-0.1-0.04*he-adj,0.4)*sf,0.4*sf,0.1*sf,0.475*sf,0.15*sf,0.04*he*sf);
fb5=sdf(posb+vec3(-0.4,-0.1-0.04*he-adj,0.2)*sf,0.1*sf,0.1*sf,0.15*sf,0.15*sf,0.04*he*sf);
fb6=sdf(posb+vec3(-0.4,-0.1-0.04*he-adj,-0.2)*sf,0.1*sf,0.1*sf,0.15*sf,0.15*sf,0.04*he*sf);

d=(opU(vec2(d1,1),vec2(f1,1))).x;
d=(opS(vec2(d,1),vec2(f2,1))).x;
d=(opS(vec2(d,1),vec2(f3,1))).x;
d=(opS(vec2(d,1),vec2(f4,1))).x;
d=(opS(vec2(d,1),vec2(f5,1))).x;
d=(opS(vec2(d,1),vec2(f6,1))).x;

db=fb1;
db=(opS(vec2(db,1),vec2(fb2,1))).x;
db=(opS(vec2(db,1),vec2(fb3,1))).x;
db=(opS(vec2(db,1),vec2(fb4,1))).x;
db=(opS(vec2(db,1),vec2(fb5,1))).x;
db=(opS(vec2(db,1),vec2(fb6,1))).x;

d=(opU(vec2(d,1),vec2(db,1))).x;

d=(opS(vec2(d,1),vec2(d2,1))).x;
d=(opS(vec2(d,1),vec2(d3,1))).x;
d=(opS(vec2(d,1),vec2(d4,1))).x;
d=(opS(vec2(d,1),vec2(d5,1))).x;
d=(opS(vec2(d,1),vec2(d6,1))).x;

res=opU(res,vec2(d,120.0));

return res;

return d;


float a=1.0;
float b=3.0;
float c=2.0;
float x=pos.x+2.0;
float y=pos.y;
float z=pos.z-1.0;



return d;
}















vec2 map( in vec3 pos )
{
    return map_(pos);

    vec2 res=vec2(100,-100);
    res = opU(res,vec2(sdBox(pos,vec3(7,1,7)),120));
    return res;

    
    if (sceneselect==2) return map3(pos); 
    if (sceneselect==3) return map4(pos); 
    if (sceneselect==4) return map4(pos); 
                                          

    

    vec4 p2=vec4(pos,1.0);
    p2 = Rotation * p2;
    vec3 p3=vec3(p2.xyz);

    vec4 pb2=vec4(pos,1.0);
    pb2 = Rotation2 * pb2;
    vec3 pb3=vec3(pb2.xyz);

    res=vec2(15.0, -100.0);
pos+=vec3(0.0,0.0,0.0);
const float r=1.25;
const float d2r=3.14159265359*2.0/360.0;
vec3 m1=vec3(r*sin(t1.x*d2r),r*sin(t1.y*d2r),r*sin(t1.z*d2r));
vec3 m2=vec3(r*sin(t2.x*d2r),r*sin(t2.y*d2r),r*sin(t2.z*d2r));
vec3 m3=vec3(r*sin(t3.x*d2r),r*sin(t3.y*d2r),r*sin(t3.z*d2r));

float elsize=6.0;

pos=mirror(pos);

vec4 rot1=vec4(vec3(pos+vec3(0.0,0.0,0.0)+m1).xyz,1.0)*Rotation;
vec3 rot1_=vec3(rot1.xyz);
vec2 r1 = opU(res, vec2(sdEllipsoid((rot1_), vec3(0.1*elsize, 0.1*elsize, 0.2*elsize)), 3.0) );

rot1=vec4(vec3(pos+vec3(0.0,0.0,0.0)+m2).xyz,1.0)*Rotation2;
rot1_=vec3(rot1.xyz);
vec2 r2 = opU(res, vec2(sdEllipsoid((rot1_), vec3(0.1*elsize, 0.1*elsize, 0.2*elsize)), 3.0) );

vec2 r3 = opU(res, vec2(sdEllipsoid((pos+vec3(0.0,0.0,0.0)+m3), vec3(0.15*elsize, 0.2*elsize, 0.05*elsize)), 3.0) );



res=vec2(blob3(r1.x,r2.x,r3.x),0.45);


    return res;
}









vec2 iBox( in vec3 ro, in vec3 rd, in vec3 rad )
{
    vec3 m = 1.0/rd;
    vec3 n = m*ro;
    vec3 k = abs(m)*rad;
    vec3 t1 = -n - k;
    vec3 t2 = -n + k;
	return vec2( max( max( t1.x, t1.y ), t1.z ),
	             min( min( t2.x, t2.y ), t2.z ) );
}


vec2 castRay( in vec3 ro, in vec3 rd )
{
float steps_;

    steps_=90; 
    vec2 res = vec2(-1.0,-1.0);

    
    
    

    
    

    
    vec2 tb = iBox( ro-vec3(0.5,0.4,-0.5), rd, vec3(2.0,0.41,3.0) );
    
    {
        
        
        vec2 h;
















const float precision_2 = 0.001;

float tmin2 = 1.4;
float t;
    int steps_2 = 80; 
    
    {
        t = tmin2+1.0/100.0;
        
        for( int i=0; i<steps_2 ; i++ )
        {
            h = map_( ro+rd*t );
            
            if( abs(h.x)<((precision_2)*t) )
            {
                 
                 break;
            }
            t += h.x*(0.85*0.58);
        }
        res = vec2(t,h.y);
    }

    }

    return res;
}

























vec2 _castRay( in vec3 ro, in vec3 rd )
{
    float tmin = 1.0;
    float tmax = 20.0;
    
    


    
    
    
    float tp1 = (0.0-ro.y)/rd.y; 
    float tp2 = (1.6-ro.y)/rd.y; 


    float t = tmin;
    float m = -10.0;
    for( int i=0; i<70; i++ )
    {
        float precis = 0.0001*t;
        vec2 res = map( ro+rd*t );
        if( abs(res.x)<precis ) break;
        t += res.x;
        m = res.y;
    }

    
    return vec2( t, m );
}

float softshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax )
{
    float res = 1.0;
    float t = mint;
    for( int i=0; i<16; i++ )
    {
        float h = map( ro + rd*t ).x;
        res = min( res, 8.0*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001) break;
    }
    return clamp( res, 0.0, 1.0 );
}


























vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}






vec3 calcNormal( in vec3 pos )
{
    if (rendertoshadowmap==1) return vec3(0);
    vec3 eps = vec3( normaleps, 0.0, 0.0 );
    

    vec3 nor = vec3(
        map(pos+eps.xyy).x - map(pos-eps.xyy).x,
        map(pos+eps.yxy).x - map(pos-eps.yxy).x,
        map(pos+eps.yyx).x - map(pos-eps.yyx).x );
    return normalize(nor);

}

float calcAO( in vec3 pos, in vec3 nor )
{
    float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + 0.12*float(i)/4.0;
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        occ += -(dd-hr)*sca;
        sca *= 0.95;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );
}

vec3 render( in vec3 ro, in vec3 rd )
{
vec3 pos;
    
    vec3 col = vec3(0.2, 0.0, 0.0) + vec3(1.0, 0.0, 0.0)*rd.y;
    vec2 res = castRay(ro,rd);
    float t = res.x;
    float m = res.y;


        pos = ro + t*rd;
        poz=vec4(pos.xyz,1.0);
        poz=mat4cam*poz;
        float zp2 = poz.z;
        float wp2 = poz.w;
        float x22 = zp2/wp2;
        x22=zp2/wp2*depthmult-depthmax;

        if (res.y<0.0) {
            if (renderdepth==0)
                col=texture2D(colorMap, texCoord).rgb;
            else
                col=vec3(1,1,1);
            return col;
        } else if (renderdepth==0)
        {
            col = vec3(0.6,0.6,0.9);
            vec3 lin = vec3(0.0);
            vec3 nor = calcNormal( pos );
            vec3 ref = reflect( rd, nor );
            for (int i=0;i<MAX_LIGHTS;i++){
                vec3 lig;
                lig = normalize(vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i])*120.0);
                float amb = clamp( 0.5+0.5*nor.y, 0.0, 1.0 );
                float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
                
                
                
                float spe = pow(clamp( dot( ref, lig ), 0.0, 1.0 ),16.0/1.5);

                
                
                const float boost=1.65;
                
                
                
                lin += 1.30*dif*vec3(lightsDiffuser[i],lightsDiffuseg[i],lightsDiffuseb[i])*boost;
                lin += 2.00*spe*vec3(lightsSpecularr[i],lightsSpecularg[i],lightsSpecularb[i])*dif*boost*11.0;
                lin += 0.40*amb*vec3(0.70,0.70,0.70)*boost;

                
                
                
            }
            vec3 col2 = col*(lin/6.0/1.2);
            col2.r/=1.3;

            lin = vec3(0.0);
            col = vec3(0.6,0.6,0.9);
            vec3 lig;
            lig = normalize( vec3(-0.4, 0.7, -0.6) );
            float amb = clamp( 0.5+0.5*nor.y, 0.0, 1.0 );
            float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
            
            
            
            float spe = pow(clamp( dot( ref, lig ), 0.0, 1.0 ),16.0/1.5);

            
            
            const float boost=1.65;
            lin += 1.30*dif*vec3(0.80,0.80,1.0)*boost;
            lin += 2.00*spe*vec3(0.9,0.9,1.00)*dif*boost;
            lin += 0.40*amb*vec3(0.70,0.70,0.70)*boost;

            col = col*lin;

            col=mix(col,col2,0.5);

            return col;
        } else {
            
            col = vec3(0.2);
            return col;
        }

        










        bool rmbkgnd2=false;
        if (rendertoshadowmap==1) {
        x22=poz.z/200.0;
        
        if (res.x==-1.0) rmbkgnd2=true;
        }
        if(x22>depth||rmbkgnd2)
        
        {
            col=texture2D(colorMap, texCoord).rgb;
            return col;
        }
















    
    {

        pos = ro + t*rd;
        vec3 nor = calcNormal( pos );
        vec3 ref;
        if (sceneselect==0||sceneselect==2||sceneselect==3||sceneselect==4)
            ref = reflect( rd, nor );
        if (sceneselect==1)
            if (refractmode==0)
                ref = refract( normalize(rd), normalize(nor), rfactor); 
            else
                ref = refract( normalize(rd), normalize(nor), 1.35); 

        if (sceneselect==1){
            ref.x=clamp(ref.x,-0.5,0.5);
            ref.y=clamp(ref.y,-1.0,1.0);
            ref.z=clamp(ref.z,-1.0,0.0); 
        }



        vec3 envcol;
        if (sceneselect==1){
            
            if (refractmode==0)
                envcol=texture(envMap, vec3(-ref.x,ref.y,-ref.z)).rgb;
            else
                envcol=texture(envMap, vec3(ref.x,-ref.y,-ref.z)).rgb;
        }
        else
            envcol=texture(envMap, vec3(ref.x,-ref.y,-ref.z)).rgb;
        
        
        col = 0.05 + 0.95*-sin( vec3(0.7,0.7,0.7)*(m-1.0) );
        if (sceneselect==0)
            col = vec3(0.2,0.2,0.6);
        else
            if (sceneselect==3||sceneselect==4){
                col = col + pow(res.y,4.5)*vec3(0.75,0.75,0.75)*0.66;
                
                
            }
            else
                col = col + pow(res.y,4.5)*vec3(-0.9,0.1,1.1)*0.66;
        

        
        
        vec3  lig = normalize( vec3(-0.4, 0.7, -0.6) );
        float amb = clamp( 0.5+0.5*nor.y, 0.0, 1.0 );
        float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
        
        
        
        float spe = pow(clamp( dot( ref, lig ), 0.0, 1.0 ),16.0/1.5);

        
        

        vec3 lin = vec3(0.0);
const float boost=1.65;
        lin += 1.30*dif*vec3(1.00,0.80,0.55)*boost;
        lin += 2.00*spe*vec3(1.00,0.90,0.70)*dif*boost;
        lin += 0.40*amb*vec3(0.70,0.70,0.70)*boost;
        
        
        
        col = col*lin;

        if (sceneselect==1){
            col=col*1.2;
            const float p=2.0;
            float g=pow(col.r,p);
            float r=pow(col.g,p);
            float b=pow(col.b,p);
            col=vec3(r,g,b)+envcol;
        }
        else
            col = col/2.75+envcol;
        
    }
    if (sceneselect==2) 
    {
        
        float m=(col.r+col.g+col.b)/3.0;
        m=clamp(m,2.0/256.0,1.0-3.0/256.0);
        col=texture2D(palette, vec2(m,4.0/256.0)).rgb;
        col.r=clamp(col.r-0.225/4.25,2.0/256.0,1.0-2.0/256.0);
        col.g=clamp(col.g+0.15/4.25,2.0/256.0,1.0-2.0/256.0);
    }

    
    if (sceneselect==3) {
        
        float m=(col.r+col.g+col.b)/3.0;
        m=clamp(m,0.0,1.0-2.0/256.0);
        col=texture2D(palette, vec2(m,useindex/20.0)).rgb;
        
    }
    









poz=vec4(pos.xyz,1.0);
poz=mat4cam*poz;
float zp = poz.z;
float wp = poz.w;
float x2 = zp/wp;
x2=zp/wp*depthmult-depthmax;


bool rmbkgnd=false;
if (rendertoshadowmap==1) {
    x2=poz.z/200.0;
    
    if (res.x==-1.0) rmbkgnd=true;
}
    if(x2>depth||rmbkgnd)
    
    {
        col=texture2D(colorMap, texCoord).rgb;
    }
    else
    {
        if (rendertoshadowmap==1){
            float depthx=x2;

            float x2=depthx*(65536*256);
            float r2=floor(x2/(65536)); x2=x2-r2*(65536);
            float g2=floor(x2/(256)); x2=x2-g2*(256);
            float b2=floor(x2/(1)); x2=x2-b2*(1);

            float r1=float(r2/256.0);
            float g1=float(g2/256.0);
            float b1=float(b2/256.0);

            col = vec3(r1,g1,b1);
        }
    }

    return vec3(clamp(col,0.0,1.0));
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{

    vec3 cw = normalize(ta-ro);

    
    vec3 cp = upvector;

    vec3 cu = normalize( cross(cw,cp) );
    vec3 cv = normalize( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

void mainImage( inout vec4 fragColor, in vec2 fragCoord )
{

    vec3 tot = vec3(0.0);
#if AA>1
    for( int m=0; m<AA; m++ )
        for( int n=0; n<AA; n++ )
        {
            
            vec2 o = vec2(float(m),float(n)) / float(AA) - 0.5;
            vec2 p = (-iResolution.xy + 2.0*(fragCoord+o))/iResolution.y;
#else
    vec2 p = (-iResolution.xy + 2.0*fragCoord)/iResolution.y;
#endif

            
            vec3 ro;
            vec3 ta;


            ro=rayorigin;
            ta=raydirection;

            
            ca = setCamera( ro, ta, 0.0 );
            

            
            
    
      vec3 rd = ca * normalize( vec3(p.x,p.y,fov ) );
            
            

ro = vec3(0.0,0.0,3.0);
rd = normalize(vec3(p-vec2(0.0,0.0),-2.0*0.72));

            
            vec3 col = render( ro, rd );

            
            

            tot += col;
#if AA>1
        }
    tot /= float(AA*AA);
#endif


    fragColor = vec4( tot, 1.0 );
}

void main()
{
    totalcolor=vec3(0,0,0);
    totalindex=0.0;

    vec2 r=gl_FragCoord.xy/vec2(1920.0,1080.0);
    
    float a=1.15;
    if (r.x<0.25*a||r.x>1.0-0.25*a||r.y<0.2*a||r.y>1.0-0.2*a)
    {
        if (renderdepth==1)
            gl_FragColor =vec4(1,1,1,1);
        else
            gl_FragColor =texture2D(colorMap, texCoord);
    }
    else
    {
        

        vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
        mainImage(color, gl_FragCoord.xy);

        gl_FragColor = color;
    }
}
